/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.rcx.materialis.MaterialisResources;
import com.rcx.materialis.modifiers.RunedModifier;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fml.ModList;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.SwappableModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import vazkii.quark.api.IRuneColorProvider;

public class RuneModifierRecipe
extends SwappableModifierRecipe {
    boolean enabled = ModList.get().isLoaded("quark");
    private final String value;

    public RuneModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierId result, String value, @Nullable SlotType.SlotCount slots) {
        super(id, inputs, toolRequirement, maxToolSize, requirements, requirementsError, result, value, slots);
        this.value = value;
    }

    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        SlotType.SlotCount slots;
        ValidatedResult commonError;
        boolean needsModifier;
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from((ItemStack)tinkerable);
        ModifierId modifier = this.result.getId();
        if (tool.getUpgrades().getLevel(modifier) == 0) {
            needsModifier = true;
            commonError = this.validatePrerequisites(tool);
        } else {
            needsModifier = false;
            commonError = this.validateRequirements(tool);
        }
        if (commonError.hasError()) {
            return commonError;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (needsModifier && (slots = this.getSlots()) != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        persistentData.putString((ResourceLocation)modifier, this.value);
        if (needsModifier) {
            tool.addModifier(this.result.getId(), 1);
        } else {
            tool.rebuildStats();
        }
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        if (this.enabled) {
            for (int i = 0; i < inv.getInputCount(); ++i) {
                if (!(inv.getInput(i).m_41720_() instanceof IRuneColorProvider)) continue;
                persistentData.put(RunedModifier.RUNE, (Tag)inv.getInput(i).serializeNBT());
                break;
            }
        }
        return ValidatedResult.success((ItemStack)tool.createStack(Math.min(tinkerable.m_41613_(), this.shrinkToolSlotBy())));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MaterialisResources.runeModifierSerializer.get();
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<RuneModifierRecipe> {
        protected ModifierEntry readResult(JsonObject json) {
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            return new ModifierEntry(ModifierId.getFromJson((JsonObject)result, (String)"name"), 1);
        }

        public RuneModifierRecipe fromJson(ResourceLocation id, JsonObject json, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            String value = GsonHelper.m_13906_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (String)"value");
            return new RuneModifierRecipe(id, ingredients, toolRequirement, maxToolSize, requirements, requirementsError, result.getId(), value, slots);
        }

        public RuneModifierRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int size = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((FriendlyByteBuf)buffer));
            }
            String value = buffer.m_130277_();
            return new RuneModifierRecipe(id, (List<SizedIngredient>)builder.build(), toolRequirement, maxToolSize, requirements, requirementsError, result.getId(), value, slots);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, RuneModifierRecipe recipe) {
            super.toNetworkSafe(buffer, (AbstractModifierRecipe)recipe);
            buffer.m_130130_(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.m_130070_(recipe.value);
        }
    }
}

